package com.agilex.healthcare.veteranappointment.domain;



import javax.validation.constraints.Min;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VeteranAppointmentConfiguration {

    @NotNull
    @Min(4)
    @Max(33)
    @Value("${numberOfMonthsForFutureAppointments}")
    public int numberOfMonthsForFutureAppointments;

    public void setNumberOfMonthsForFutureAppointments(int numberOfMonthsForFutureAppointments){
        this.numberOfMonthsForFutureAppointments = numberOfMonthsForFutureAppointments;
    }


    public int getNumberOfMonthsForFutureAppointments(){
        return this.numberOfMonthsForFutureAppointments;
    }

}
